/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.editor.FmtAfdPanel;
import com.quantumdata.fmteditor.editor.FmtChecker;
import com.quantumdata.fmteditor.editor.FmtDigitalAudioPanel;
import com.quantumdata.fmteditor.editor.FmtDigitalVideoPanel;
import com.quantumdata.fmteditor.editor.FmtSyncPanel;
import com.quantumdata.fmteditor.editor.FmtTimingPanel;
import com.quantumdata.fmteditor.editor.Problem;
import com.quantumdata.fmteditor.editor.ProblemTable;
import com.quantumdata.fmteditor.editor.UnitType;
import com.quantumdata.fmteditor.editor.Xvsi;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.Format;
import com.quantumdata.fmteditor.fmtwidgets.ConnectPanel;
import com.quantumdata.fmteditor.fmtwidgets.FmtComboBox;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class FmtEditorFrame
extends FmtFrameBase {
    private Format m_fmt;
    private JTabbedPane m_tabs;
    private FmtSyncPanel m_syncPanel;
    private FmtTimingPanel m_timingPanel;
    private FmtDigitalAudioPanel m_digAudioPanel;
    private FmtDigitalVideoPanel m_digVideoPanel;
    private FmtAfdPanel m_afdPanel;
    private Vector<Problem> m_checkResults = new Vector();
    private ProblemTable m_problemTable;
    private FmtChecker m_checker;
    private JComboBox m_xvsi;
    private JComboBox m_unit;
    private QDButton m_useBtn;
    private ConnectPanel m_conPanel;

    public FmtEditorFrame(Format format) {
        super("", true, true, true, true);
        Object object;
        this.setFileType(FmtFileType.FORMAT);
        this.m_fmt = format;
        this.m_checker = new FmtChecker(this.m_fmt);
        this.setLayout(new BorderLayout());
        this.m_tabs = new QDTabbedPane();
        this.m_timingPanel = new FmtTimingPanel(this.m_fmt);
        this.m_tabs.addTab("Timing", (Component)((Object)this.m_timingPanel));
        this.m_syncPanel = new FmtSyncPanel(this.m_fmt);
        this.m_tabs.addTab("General", (Component)((Object)this.m_syncPanel));
        this.m_digVideoPanel = new FmtDigitalVideoPanel(this.m_fmt);
        this.m_tabs.addTab("Digital Video", (Component)((Object)this.m_digVideoPanel));
        this.m_digAudioPanel = new FmtDigitalAudioPanel(this.m_fmt);
        this.m_tabs.addTab("Digital Audio", (Component)((Object)this.m_digAudioPanel));
        this.m_afdPanel = new FmtAfdPanel(this.m_fmt);
        this.m_tabs.addTab("AFD", (Component)((Object)this.m_afdPanel));
        JSplitPane jSplitPane = new JSplitPane(0, true, this.m_tabs, (Component)this.createProblemPanel());
        this.add(jSplitPane, "Center");
        jSplitPane.setEnabled(false);
        jSplitPane.setDividerSize(4);
        jSplitPane.setForeground(QDStdUI.getBackground());
        jSplitPane.setBackground(QDStdUI.getBackground());
        if (jSplitPane.getUI() instanceof BasicSplitPaneUI) {
            object = (BasicSplitPaneUI)jSplitPane.getUI();
            ((BasicSplitPaneUI)object).getDivider().setBorder(BorderFactory.createLineBorder(QDStdUI.getButtonDark(), 4));
            ((BasicSplitPaneUI)object).getDivider().setBackground(QDStdUI.getButtonDark());
            ((BasicSplitPaneUI)object).getDivider().setForeground(QDStdUI.getButtonDark());
        }
        object = new ChangeListener();
        for (CmdValue cmdValue : this.m_fmt.getValues()) {
            cmdValue.addListener((CmdValueListener)object);
        }
        this.checkFormat();
        this.checkConnection();
        this.m_fmt.markUnmodified();
    }

    public Format getFormat() {
        return this.m_fmt;
    }

    private QDPanel createProblemPanel() {
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel3 = new QDPanel();
        QDLabel qDLabel = new QDLabel("Problem List:   ");
        qDLabel.setForeground(QDStdUI.getActionForeground());
        qDPanel3.add((Component)qDLabel);
        this.m_unit = new FmtComboBox((Object[])UnitType.values());
        this.m_unit.setSelectedIndex(0);
        this.m_unit.setToolTipText("Unit (Instrument) type used for problem checking");
        this.m_unit.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FmtEditorFrame.this.updateXvsiList();
                FmtEditorFrame.this.checkFormat();
            }
        });
        qDPanel3.add((Component)new QDLabel("Unit: "));
        qDPanel3.add((Component)this.m_unit);
        this.m_xvsi = new FmtComboBox();
        this.updateXvsiList();
        this.m_xvsi.setToolTipText("The Interface (XVSI) used for problem checking");
        this.m_xvsi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FmtEditorFrame.this.checkFormat();
            }
        });
        qDPanel3.add((Component)new QDLabel("    Interface: "));
        qDPanel3.add((Component)this.m_xvsi);
        qDPanel2.add((Component)qDPanel3, (Object)"West");
        qDPanel3 = new QDPanel();
        this.m_useBtn = new QDButton("   Use   ");
        this.m_useBtn.setToolTipText("Use (test) this format on the connected instrument");
        this.m_useBtn.useSmallFont(true);
        this.m_useBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FmtEditorFrame.this.useFormat();
            }
        });
        this.m_conPanel = new ConnectPanel((JComponent)((Object)this));
        this.m_conPanel.useCompactForm(true);
        qDPanel3.add((Component)((Object)this.m_conPanel));
        qDPanel3.add((Component)this.m_useBtn);
        qDPanel2.add((Component)qDPanel3, (Object)"East");
        qDPanel.add((Component)qDPanel2, (Object)"North");
        this.m_problemTable = new ProblemTable();
        JScrollPane jScrollPane = new JScrollPane(this.m_problemTable);
        jScrollPane.getViewport().setBackground(QDStdUI.getBackground());
        jScrollPane.setOpaque(true);
        jScrollPane.setBackground(QDStdUI.getBackground());
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        qDPanel.add((Component)jScrollPane, (Object)"Center");
        this.m_conPanel.setListener(new InstrumentListener(){

            public void connected(RemoteInstrument remoteInstrument) {
                FmtEditorFrame.this.checkConnection();
            }

            public void disconnected(RemoteInstrument remoteInstrument) {
                FmtEditorFrame.this.checkConnection();
            }
        });
        return qDPanel;
    }

    private void checkFormat() {
        Xvsi xvsi = (Xvsi)((Object)this.m_xvsi.getSelectedItem());
        if (xvsi == null) {
            return;
        }
        UnitType unitType = (UnitType)((Object)this.m_unit.getSelectedItem());
        if (unitType == null) {
            return;
        }
        this.m_checker.check(xvsi, unitType, this.m_checkResults);
        this.m_problemTable.setProblems(this.m_checkResults);
    }

    private void useFormat() {
        FmtEditorMain.instance().useFormat(this.m_fmt, this);
    }

    private void checkConnection() {
        this.m_useBtn.setEnabled(false);
        if (this.isConnected()) {
            this.m_useBtn.setEnabled(true);
        }
    }

    private void updateXvsiList() {
        UnitType unitType = UnitType.values()[this.m_unit.getSelectedIndex()];
        this.m_xvsi.removeAllItems();
        switch (unitType) {
            case C_CA: {
                this.m_xvsi.addItem(Xvsi.ANALOG);
                this.m_xvsi.addItem(Xvsi.CVBS);
                this.m_xvsi.addItem(Xvsi.SVIDEO);
                this.m_xvsi.addItem(Xvsi.HDMI_D);
                this.m_xvsi.addItem(Xvsi.HDMI_H);
                this.m_xvsi.addItem(Xvsi.SDI);
                this.m_xvsi.setSelectedIndex(0);
                break;
            }
            case D: {
                this.m_xvsi.addItem(Xvsi.DVI_A);
                this.m_xvsi.addItem(Xvsi.CVBS);
                this.m_xvsi.addItem(Xvsi.SVIDEO);
                this.m_xvsi.addItem(Xvsi.DVI_D);
                this.m_xvsi.addItem(Xvsi.HDMI_D);
                this.m_xvsi.addItem(Xvsi.HDMI_H);
                this.m_xvsi.addItem(Xvsi.SDI);
                this.m_xvsi.setSelectedIndex(0);
                break;
            }
            case E: {
                this.m_xvsi.addItem(Xvsi.ANALOG);
                this.m_xvsi.addItem(Xvsi.CVBS);
                this.m_xvsi.addItem(Xvsi.SVIDEO);
                this.m_xvsi.addItem(Xvsi.HDMI_D);
                this.m_xvsi.addItem(Xvsi.HDMI_H);
                break;
            }
            case EA_DP: {
                this.m_xvsi.addItem(Xvsi.HDMI_D);
                this.m_xvsi.addItem(Xvsi.HDMI_H);
                this.m_xvsi.addItem(Xvsi.DPORT);
                this.m_xvsi.setSelectedIndex(1);
            }
        }
    }

    public String getDataName() {
        return this.m_fmt.getName();
    }

    public String getTypeName() {
        return "Format Editor";
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean isModified() {
        return this.m_fmt.isModified();
    }

    public void markUnmodified() {
        this.m_fmt.markUnmodified();
    }

    public String getOptTitleText() {
        if (!this.m_fmt.isLocal()) {
            return " (" + this.m_fmt.getFromIP() + ")";
        }
        return "";
    }

    public RemoteInstrument getInstrument() {
        return this.m_conPanel.getInstrument();
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_conPanel.setInstrument(remoteInstrument);
    }

    public void frameClosing() {
        this.m_conPanel.close();
    }

    public boolean isLocalFile() {
        return this.m_fmt.isLocal();
    }

    public boolean supportsRemoteFiles() {
        return true;
    }

    private class ChangeListener
    implements CmdValueListener {
        private ChangeListener() {
        }

        public void valueChanged(CmdValue cmdValue) {
            FmtEditorFrame.this.checkFormat();
            FmtEditorFrame.this.setFrameTitle();
        }
    }
}

